

// Coordonnees de texture et couleur pour le fragment

varying vec4 gl_TexCoord[];
varying vec4 gl_FrontColor;
 
uniform float u_Elapsed;

void main()
{
    vec4 displacedVertex;
    displacedVertex = gl_Vertex;

    float len = length( displacedVertex );

    displacedVertex.x += 10.0 * sin( u_Elapsed * len );
    displacedVertex.y += 100.0 * sin( u_Elapsed + len *5);
	
	// Try changing all of the above settings at random.
	// I tried changing the multipliers for plus, minus etc.
	// Sin, cos, tan, deleting the len, adding or minusing or multiplying the len, etc.
	// Try any and all combinations for different effects ;)
	// Compare with Lezardo's original.
    

    // Position sur l'ecran
    gl_Position = gl_ProjectionMatrix * gl_ModelViewMatrix * displacedVertex;


    // Position dans la texture
    gl_TexCoord[0] = gl_MultiTexCoord0;

    gl_FrontColor = gl_Color;

    

}




